/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reliquary.entities.SpecialSnowballEntity;
import reliquary.items.GlacialStaffItem;
import reliquary.items.ToggleableItem;
import reliquary.reference.Settings;
import reliquary.util.LanguageHelper;
import reliquary.util.NBTHelper;

public class IceMagusRodItem
extends ToggleableItem {
    public static final DustParticleOptions ICE_PARTICLE = new DustParticleOptions(new Vector3f(0.3882353f, 0.76862746f, 0.99215686f), 1.0f);
    private static final String SNOWBALLS_TAG = "snowballs";

    public IceMagusRodItem() {
        super(new Item.Properties().m_41487_(1).setNoRepair());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack rod, @Nullable Level world, List<Component> tooltip) {
        LanguageHelper.formatTooltip(this.m_5524_() + ".tooltip2", Map.of("charge", Integer.toString(NBTHelper.getInt(SNOWBALLS_TAG, rod))), tooltip);
        if (this.isEnabled(rod)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", Map.of("item", ChatFormatting.BLUE + Items.f_42452_.m_7626_(new ItemStack((ItemLike)Items.f_42452_)).toString()), tooltip);
        }
        LanguageHelper.formatTooltip("tooltip.absorb", null, tooltip);
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    private int getSnowballCap() {
        return this instanceof GlacialStaffItem ? (Integer)Settings.COMMON.items.glacialStaff.snowballLimit.get() : (Integer)Settings.COMMON.items.iceMagusRod.snowballLimit.get();
    }

    int getSnowballCost() {
        return this instanceof GlacialStaffItem ? (Integer)Settings.COMMON.items.glacialStaff.snowballCost.get() : (Integer)Settings.COMMON.items.iceMagusRod.snowballCost.get();
    }

    private int getSnowballWorth() {
        return this instanceof GlacialStaffItem ? (Integer)Settings.COMMON.items.glacialStaff.snowballWorth.get() : (Integer)Settings.COMMON.items.iceMagusRod.snowballWorth.get();
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        player.m_6674_(hand);
        if (!player.m_6144_() && (NBTHelper.getInt(SNOWBALLS_TAG, stack) >= this.getSnowballCost() || player.m_7500_())) {
            level.m_5594_(null, player.m_142538_(), SoundEvents.f_11687_, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.f_46441_.nextFloat() * 0.4f + 0.8f));
            SpecialSnowballEntity snowball = new SpecialSnowballEntity(level, (LivingEntity)player, this instanceof GlacialStaffItem);
            snowball.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 2.4f, 1.0f);
            level.m_7967_((Entity)snowball);
            if (!player.m_7500_()) {
                NBTHelper.putInt(SNOWBALLS_TAG, stack, NBTHelper.getInt(SNOWBALLS_TAG, stack) - this.getSnowballCost());
            }
        }
        return super.m_7203_(level, player, hand);
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.EPIC;
    }

    public void m_6883_(ItemStack rod, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.f_46443_ || world.m_46467_() % 10L != 0L || !(entity instanceof Player)) {
            return;
        }
        if (this.isEnabled(rod)) {
            int snowCharge = NBTHelper.getInt(SNOWBALLS_TAG, rod);
            this.consumeAndCharge((Player)entity, this.getSnowballCap() - snowCharge, this.getSnowballWorth(), Items.f_42452_, 16, (int chargeToAdd) -> NBTHelper.putInt(SNOWBALLS_TAG, rod, snowCharge + chargeToAdd));
        }
    }
}

